% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterGamma.R
\name{clusterGamma}
\alias{clusterGamma}
\title{Create an instance of the [\code{\linkS4class{ClusterGamma}}] class}
\usage{
clusterGamma(
  data,
  nbCluster = 2,
  models = "gamma_pk_ajk_bjk",
  strategy = clusterStrategy(),
  criterion = "ICL",
  nbCore = 1
)
}
\arguments{
\item{data}{frame or matrix containing the data. Rows correspond to observations
and columns correspond to variables. If the data set contains NA values, they
will be estimated during the estimation process.}

\item{nbCluster}{[\code{\link{vector}}] listing the number of clusters to test.}

\item{models}{[\code{\link{vector}}] of model names to run. By default all
gamma models with free shape are estimated.  All the model names are given by
the method [\code{\link{clusterGammaNames}}].}

\item{strategy}{a [\code{\linkS4class{ClusterStrategy}}] object containing
the strategy to run. [\code{\link{clusterStrategy}}]() method by default.}

\item{criterion}{character defining the criterion to select the best model.
The best model is the one with the lowest criterion value.
Possible values: "BIC", "AIC", "ICL", "ML". Default is "ICL".}

\item{nbCore}{integer defining the number of processor to use (default is 1, 0 for all).}
}
\value{
An instance of the [\code{\linkS4class{ClusterGamma}}] class.
}
\description{
This function computes the optimal gamma mixture model according
to the \code{criterion} among the list of model given in \code{models}
and the number of clusters given in \code{nbCluster}, using the strategy
specified in \code{strategy}.
}
\examples{
## A quantitative example with the famous geyser data set
data(geyser)
## add 10 missing values
x = geyser;
x[round(runif(5,1,nrow(geyser))), 1] <- NA
x[round(runif(5,1,nrow(geyser))), 2] <- NA

## use graphics functions
set.seed(2)
model <- clusterGamma( data=x, nbCluster=2:3
                     , models="gamma_pk_ajk_bjk"
                     , strategy = clusterFastStrategy())

## use plot
\donttest{
plot(model)
}

## get summary
summary(model)
\donttest{
## print model (a detailed and very long output)
print(model)
}
## get estimated missing values
missingValues(model)

}
\author{
Serge Iovleff
}
