% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmmMixedData.R
\name{kmmMixedData}
\alias{kmmMixedData}
\title{Create an instance of the [\code{\linkS4class{KmmMixedDataModel}}] class}
\usage{
kmmMixedData(
  ldata,
  lmodels,
  nbCluster = 2,
  strategy = clusterStrategy(),
  criterion = "ICL",
  nbCore = 1
)
}
\arguments{
\item{ldata}{[\code{list}] containing the data sets (matrices and/or data.frames).}

\item{lmodels}{a [\code{list}] of same length than data. It contains the model
names, kernel names and kernel parameter names to use in order to fit each
data set.}

\item{nbCluster}{[\code{\link{vector}}] with the number of clusters to test.}

\item{strategy}{a [\code{\linkS4class{ClusterStrategy}}] object containing
the strategy to run. Default is clusterStrategy().}

\item{criterion}{character defining the criterion to select the best model.
The best model is the one with the lowest criterion value.
Possible values: "BIC", "AIC", "ICL", "ML". Default is "ICL".}

\item{nbCore}{integer defining the number of processors to use (default is 1, 0 for all).}
}
\value{
An instance of the [\code{\linkS4class{KmmMixedDataModel}}] class.
}
\description{
This function computes the optimal mixture model for mixed data using kernel
mixture models according to the \code{criterion} among the number of clusters
given in \code{nbCluster} using the strategy specified in [\code{strategy}].
}
\details{
For each data set in data, we need to specify a list of parameters
}
\examples{

## An example with the bullsEye data set
data(bullsEye)
data(bullsEye.cat)
## with default values
ldata     <- list(bullsEye, bullsEye.cat)
modelcont <- list(modelName="kmm_pk_s", dim = 10, kernelName="Gaussian")
modelcat  <- list(modelName="kmm_pk_s", dim = 20, kernelName="Hamming", kernelParameters = c(0.6))
lmodels   <- list( modelcont, modelcat)

model <- kmmMixedData(ldata, lmodels, nbCluster=2:5, strategy = clusterFastStrategy())

## get summary
summary(model)


\donttest{
## use graphics functions
plot(model)
}

}
\author{
Serge Iovleff
}
