% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixbino.R
\name{mixbinosemionestep}
\alias{mixbinosemionestep}
\title{One-Step Estimation of Semiparametric Mixture of Binomial Regression with a Degenerate Component}
\usage{
mixbinosemionestep(tg, t, x, N, tune = NULL)
}
\arguments{
\item{tg}{the grid points on which we want to evaluate the function w(t) and p(t).}

\item{t}{the time variable associated with x.}

\item{x}{the integer observation.}

\item{N}{the number of experiments for Binomial distribution.}

\item{tune}{the bandwidth will be h*tune. Default will be 1.}
}
\value{
w contains the estimate of first component proportion function
pt is the estimate of component probability function for the first component
h the bandwidth
}
\description{
Fits the semiparametric mixture of binomial distribution with one degenerate component using one-step
backfitting procedure
}
\examples{

nobs=50;
tobs=seq(from=0,to=1,length.out=nobs);
pi1Tru=0.4*matrix(rep(1,nobs),nrow=nobs);
ptTru=0.3*(1.5+cos(2*pi*tobs));
nfine=nobs;
tfine=seq(from=0,to=1,length.out=nfine);
yobs=numeric();
for(i in 1:nobs){
  b=rbinom(1,1,pi1Tru[i]);
  if(b==1){
      yobs[i]=0;
   }else{
      yobs[i]=rbinom(1,7,ptTru[i]);
      }
 }
 ftCon=mixbinosemi(tfine,tobs,yobs,7);
 pi1Con=ftCon$w;
 ptCon=ftCon$pt;
 ftonestep=mixbinosemionestep(tfine,tobs,yobs,7);
 pi1onestep=ftonestep$w;
 ptonestepMat=ftonestep$pt;
}
