% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixregression.R
\name{mixlintv}
\alias{mixlintv}
\title{Robust Mixture Regression Based on T-distribution
mixlintv adaptively estimates the mixture regression parameters robustly assuming the error distribution is t-distribution}
\usage{
mixlintv(x, y, bet, sig, pr, m = 2, maxv = 15, acc = 10^(-5))
}
\arguments{
\item{x}{explanatory variables matrix with rows for each observation}

\item{y}{response variable vector}

\item{bet}{initial values for beta}

\item{sig}{initial value for sigma; if the component variance is different then use a vector, otherwise a scaler would be fine.}

\item{pr}{initial value of proportion for each component, vector}

\item{m}{number of component, default is 2}

\item{maxv}{maximum degree of freedom, default is 15}

\item{acc}{stopping criteria, default is 10^(-5)}
}
\value{
theta: estimated parameters beta(intercept, slopes), sigma, proportion for each component
likelihood: likelihood of the estimated parameter
dif:  difference of likelihood of last iteration and second to last iteration
run: number of iteration to converge
vdegree: estimated degree of the t distribution
degreerange: all degree of freedom use to estimate the parameters
vlikelihoodseq: all likelihood associated with degrees of freedom
}
\description{
Robust Mixture Regression Based on T-distribution
mixlintv adaptively estimates the mixture regression parameters robustly assuming the error distribution is t-distribution
}
