% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelFrequency.R
\name{distlat}
\alias{distlat}
\title{Euclidean Distance Based Labeling Method for Label Switching}
\usage{
distlat(est, lat)
}
\arguments{
\item{est}{a list with four elements representing the estimated mixture model,
which can be obtained using the \code{\link{mixnorm}} function. When specified,
it has the form of \code{list(mu, sigma, pi, p)}, where
\code{mu} is a C by p matrix of estimated component means where p is the dimension of data
and C is the number of mixture components,
\code{sigma} is a p by p matrix of estimated common standard deviation for all components
(when the data is multi-dimensional) or a C-dimensional vector of estimated component
standard deviations (when the data is one-dimensional),
\code{pi} is a C-dimensional vector of mixing proportions, and
\code{p} is a C by n matrix of the classification probabilities,
where the (i, j)th element corresponds to the probability of the jth observation
belonging to the ith component.}

\item{lat}{a C by n zero-one matrix representing the latent component labels for all observations,
where C is the number of components in the mixture model and n is the number of observations.
If the (i, j)th cell is 1, it indicates that the jth observation belongs to the ith component.}
}
\value{
The estimation results adjusted to account for potential label switching problems are returned,
as a list containing the following elements:
\item{mu}{C by p matrix of estimated component means.}
\item{sigma}{C-dimensional vector of estimated component standard deviations (for univariate data) or
p by p matrix of estimated component variance (for multivariate data).}
\item{pi}{C-dimensional vector of estimated mixing proportions.}
}
\description{
`distlat' is used to address the label switching problem by minimizing
the distance between the classification probabilities and the latent component label,
which is the label used by the user to generate the sample (Yao, 2015).
The function supports both one-dimensional (with equal variances or unequal variances)
and multi-dimensional data (with equal variances).
}
\examples{
# See examples for the `complh' function.
}
\references{
Yao, W. (2015). Label switching and its solutions for frequentist mixture models.
Journal of Statistical Computation and Simulation, 85(5), 1000-1012.
}
\seealso{
\code{\link{complh}}, \code{\link{mixnorm}}
}
