% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bv.standardization.R
\name{bv.standardization}
\alias{bv.standardization}
\title{BV standardization}
\usage{
bv.standardization(population, mean.target = 100, var.target = 10,
  gen = NULL, database = NULL, cohorts = NULL, adapt.bve = FALSE,
  adapt.pheno = FALSE, verbose = FALSE)
}
\arguments{
\item{population}{Population list}

\item{mean.target}{Target mean}

\item{var.target}{Target variance}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{database}{Groups of individuals to consider for the export}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{adapt.bve}{Modify previous breeding value estimations by scaling (default: FALSE)}

\item{adapt.pheno}{Modify previous phenotypes by scaling (default: FALSE)}

\item{verbose}{Set to TRUE to display prints}
}
\value{
Population-list with scaled QTL-effects
}
\description{
Function to get mean and genetic variance of a trait to a fixed value
}
\examples{
population <- creating.diploid(nsnp=1000, nindi=100, n.additive=100)
population <- bv.standardization(population, mean.target=200, var.target=5)
}
