% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/conditional.R
\name{BICMultiFunctions}
\alias{BICMultiFunctions}
\title{BIC for Multiple Functions}
\usage{
BICMultiFunctions(Px, X)
}
\arguments{
\item{Px}{A list with 'n' elements. Each element contains a \code{"motbf"} function.}

\item{X}{A list with 'n' elements. Each one contains a \code{"numeric"} vector with the
values of the data set which correspond to the diferent functions.}
}
\value{
The \code{"numeric"} BIC value.
}
\description{
Compute the BIC score for more than one function
}
\examples{
## Data
X <- rnorm(500)
Y <- rnorm(500, mean=1)
data <- data.frame(X=X, Y=Y)
## Data as a "list"
Xlist <- sapply(data, list)

## Learning as a "list"
Plist <- lapply(data, univMoTBF, POTENTIAL_TYPE="MOP")
Plist

## BIC value
BICMultiFunctions(Px=Plist, X=Xlist)
}
\seealso{
\link{univMoTBF}
}

