% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearningBN.R
\name{printBN}
\alias{printBN}
\title{Prints BN Results}
\usage{
printBN(MoTBF.BN)
}
\arguments{
\item{MoTBF.BN}{The output of the method \code{MoTBFs_Learning()}.}
}
\value{
The results of the fitted functions in the full network.
}
\description{
Prints the results of a hybrid Bayesian network
}
\examples{

## Dataset Ecoli
require(MoTBFs)
data(ecoli)
data <- ecoli[,-c(1)] ## remove variable sequence

## Directed acyclic graph
dag <- LearningHC(data)

## Learning BN
intervals <- 3
potential <- "MOP"
P <- MoTBFs_Learning(graph = dag, data = data, numIntervals = intervals, POTENTIAL_TYPE=potential,
maxParam = 15)
printBN(P)

}
\seealso{
\link{MoTBFs_Learning}
}
