% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearningBN.R
\name{goodnessMoTBFBN}
\alias{goodnessMoTBFBN}
\alias{logLikelihood.MoTBFBN}
\alias{BiC.MoTBFBN}
\title{BIC of a hybrid BN}
\usage{
logLikelihood.MoTBFBN(MoTBF.BN, data)

BiC.MoTBFBN(MoTBF.BN, data)
}
\arguments{
\item{MoTBF.BN}{The output of the 'MoTBF_Learning' method.}

\item{data}{The dataset of class \code{data.frame}.}
}
\value{
A numeric value giving the log-likelihood of the BN.
}
\description{
Compute the BIC score and the loglikelihood from the fitted MoTBFs functions 
in a hybrid Bayesian network.
}
\examples{

## Dataset Ecoli
require(MoTBFs)
data(ecoli)
data <- ecoli[,-c(1)] ## remove variable sequence

## Directed acyclic graph
dag <- LearningHC(data)

## Learning BN
intervals <- 3
potential <- "MOP"
P1 <- MoTBFs_Learning(graph = dag, data = data, POTENTIAL_TYPE=potential,
numIntervals = intervals, maxParam = 5)
logLikelihood.MoTBFBN(P1, data) ##BIC$LogLikelihood
BIC <- BiC.MoTBFBN(P1, data)
BIC$BIC

## Learning BN
intervals <- 2
potential <- "MTE"
P2 <- MoTBFs_Learning(graph = dag, data = data, POTENTIAL_TYPE=potential,
numIntervals = intervals, maxParam = 10)
logLikelihood.MoTBFBN(P2, data) ##BIC$LogLikelihood
BIC <- BiC.MoTBFBN(P2, data)
BIC$BIC 
}
\seealso{
\link{MoTBFs_Learning}
}
