% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babel-import.R
\name{chc2Out}
\alias{chc2Out}
\title{Converts chain-coded coordinates to Out object}
\usage{
chc2Out(chc, skip, names)
}
\arguments{
\item{chc}{a path to the chc file}

\item{skip}{numeric how many informations before the first chain-coded information}

\item{names}{an (optional) vector of (skip) names for the \code{fac} created.
Somehow similar to \code{names} in \link{lf_structure}}
}
\description{
For Shape/ChainCoder files, a wrapper to convert chain-coded coordinates to
\code{\link{Out}} objects.
}
\details{
Files from Shape/ChainCoder comes this way:
\preformatted{
Name_1 fac1 fac2 fac3 [...] 6 6 6 6 6 6 6 6 7 6 [...] -1
Name_2 fac1 fac2 fac3 [...] 6 6 6 6 5 5 7 6 7 6 [...] -1
}
This function does the following:
\enumerate{
\item take everything before the first chain-coded
coordinate (here a "6") and transform it into a \code{data.frame}, later used
as a \code{fac}
\item convert all the chain-coded coordinates into (x; y) coordinates
using \link{chc2pix}
(and removes) the "-1" that mark the end of coordinates
\item returns an \code{\link{Out}} object with the corresponding \code{fac}
and with outlines named after the first \code{fac} column
(here with Name_1, Name_2, etc.)
}
This function needs to know how many information (space-separated there is
before) the first coordinate. On the example above, would be 4 id [...] was empty.
}
\note{
I'm not very familiar to other morphometric formats.
So if you have troubles importing your datasets, contact me, I can help. Or if you fix something,
please let met know!
}
\examples{
\dontrun{
# if the file above was called 'coded.chc' in the 'data' folder:
chc2Out("data/coded.chc", skip=4)
}
}
\references{
Kuhl, F. P., & Giardina, C. R. (1982).
Elliptic Fourier features of a closed contour.
\emph{Computer Graphics and Image Processing}, 18(3), 236-258.
}
\seealso{
\link{pix2chc}

Other babel functions: \code{\link{bind_db}},
  \code{\link{chc2pix}},
  \code{\link{import_StereoMorph_curve1}},
  \code{\link{import_jpg}}, \code{\link{import_tps}},
  \code{\link{nef2Coe}}, \code{\link{ntsrow2Coo}},
  \code{\link{pix2chc}}, \code{\link{tie_jpg_txt}},
  \code{\link{tps2coo}}
}
