% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-opn-dct.R
\name{dfourier}
\alias{dfourier}
\alias{dfourier.default}
\alias{dfourier.Opn}
\alias{dfourier.Coo}
\title{Discrete cosinus transform}
\usage{
dfourier(coo, nb.h)

\method{dfourier}{default}(coo, nb.h)

\method{dfourier}{Opn}(coo, nb.h)

\method{dfourier}{Coo}(coo, nb.h)
}
\arguments{
\item{coo}{a matrix (or a list) of (x; y) coordinates}

\item{nb.h}{numeric the number of harmonics to calculate}
}
\value{
a list with the following components:
\itemize{
\item an the A harmonic coefficients
\item bn the B harmonic coefficients
\item mod the modules of the points
\item arg the arguments of the points
}
}
\description{
Calculates discrete cosine transforms, as introduced by Dommergues and colleagues, on
a shape (mainly open outlines).
}
\note{
This method has been only poorly tested in Momocs and should be considered as
experimental. Yet improved by a factor 10, this method is still long to execute.
It will be improved in further releases but it should not be so painful right now.
It also explains the progress bar. Shapes should be aligned
before performing the dct transform.

Silent message and progress bars (if any) with \code{options("verbose"=FALSE)}.
}
\examples{
\dontrun{ # because it's long
od <- dfourier(olea)
od
op <- PCA(od)
plot(op, 1)
}
# dfourier and inverse dfourier
o <- olea[1]
o <- coo_bookstein(o)
coo_plot(o)
o.dfourier <- dfourier(o, nb.h=12)
o.dfourier
o.i <- dfourier_i(o.dfourier)
o.i <- coo_bookstein(o.i)
coo_draw(o.i, border='red')

#future calibrate_reconstructions
o <- olea[1]
h.range <- 2:13
coo <- list()
for (i in seq(along=h.range)){
coo[[i]] <- dfourier_i(dfourier(o, nb.h=h.range[i]))}
names(coo) <- paste0('h', h.range)
panel(Opn(coo), borders=col_india(12), names=TRUE)
title('Discrete Cosine Transforms')
}
\references{
\itemize{
\item Dommergues, C. H., Dommergues, J.-L., & Verrecchia, E. P. (2007).
The Discrete Cosine Transform, a Fourier-related Method for Morphometric Analysis of Open Contours.
\emph{Mathematical Geology}, 39(8), 749-763. doi:10.1007/s11004-007-9124-6
\item Many thanks to Remi Laffont for the translation in R).
}
}
\seealso{
Other dfourier: \code{\link{dfourier_i}},
  \code{\link{dfourier_shape}}
}
