% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-misc.R
\name{col_transp}
\alias{col_transp}
\alias{col_alpha}
\title{Transparency helpers and palettes}
\usage{
col_transp(n, col = "#000000", ceiling = 1)

col_alpha(cols, transp = 0)
}
\arguments{
\item{n}{the number of colors to generate}

\item{col}{a color in hexadecimal format on which to generate levels of transparency}

\item{ceiling}{the maximal opacity (from 0 to 1)}

\item{cols}{on or more colors, provided as hexadecimal values}

\item{transp}{numeric between 0 and 1, the value of the transparency to obtain}
}
\description{
To ease transparency handling.
}
\examples{
x <- col_transp(10, col='#000000')
x
barplot(1:10, col=x, main='a transparent black is grey')

summer10 <- col_summer(10)
summer10
summer10.transp8 <- col_alpha(summer10, 0.8)
summer10.transp8
summer10.transp2 <- col_alpha(summer10, 0.8)
summer10.transp2
x <- 1:10
barplot(x, col=summer10.transp8)
barplot(x/2, col=summer10.transp2, add=TRUE)
}
