% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-ldk-utilities.R
\name{rearrange_ldk}
\alias{rearrange_ldk}
\title{Rearrange, (select and reorder) landmarks to retain}
\usage{
rearrange_ldk(Coo, new_ldk_ids)
}
\arguments{
\item{Coo}{any appropriate \code{Coo} object (typically an \code{Ldk})
with landmarks inside}

\item{new_ldk_ids}{a vector of numeric with the ldk to retain \emph{and}
in the right order (see below)}
}
\description{
Helps reorder and retain landmarks by simply changing the order in which they
are recorded in the \code{Coo} objects. Note that for \code{Out} and \code{Opn}
objects, this rearranges the \code{$ldk} component. For \code{Ldk}, it rearranges
the \code{$coo} directly.
}
\examples{
# Out example
hearts \%>\% slice(1) \%T>\% stack \%$\% ldk
hearts \%>\% rearrange_ldk(c(4, 1)) \%>\%
       slice(1) \%T>\%stack \%$\% ldk

# Ldk example
wings \%>\% slice(1) \%T>\% stack \%$\% coo
wings \%>\% rearrange_ldk(c(1, 3, 12:15)) \%>\%
      slice(1) \%T>\% stack \%$\% coo
}
\seealso{
Other ldk/slidings methods: 
\code{\link{add_ldk}()},
\code{\link{def_ldk}()},
\code{\link{def_slidings}()},
\code{\link{get_ldk}()},
\code{\link{get_slidings}()},
\code{\link{slidings_scheme}()}
}
\concept{ldk/slidings methods}
