% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Input_floads.R
\name{loading.value}
\alias{loading.value}
\title{This function specifies factor loading values.}
\usage{
loading.value(nf, fl.loads)
}
\arguments{
\item{nf}{the number of factor/s.}

\item{fl.loads}{vector of factor loadings}
}
\value{
The function returns factor loading matrix. The number of column shows the number of factor in the model. The rows show number of items
}
\description{
The user specifies the factor loadings as a matrix. The values should be given by column for each factor.
Columns represent factors and rows represent items.
The values entered should be larger than 0 and smaller then 1.
Please see the example for a loading matrix for three-factor model.
}
\examples{
# This example represents a three-factor CFA model
#  where the factors are indicated by 3, 3 and 2 items respectively.
#
loading.value(nf=3, fl.loads=c(.6,.6,.6,0,0,0,0,0,0,0,0,.7,.7,.7,0,0,0,0,0,0,0,0,.8,.8))
}
\author{
Fatih Orçan
}
