% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kannisto.R
\name{kannisto.predict}
\alias{kannisto.predict}
\title{Kannisto Prediction}
\usage{
kannisto.predict(pars, ages)
}
\arguments{
\item{pars}{A named vector with Kanisto coefficients \eqn{c} and \eqn{d} 
(e.g. result of \code{\link{kannisto.estimate}} or \code{\link{cokannisto.estimate}}).}

\item{ages}{A vector of ages to make prediction for.}
}
\value{
Vector of predicted mortality rates.
}
\description{
Given estimated Kannisto parameters (coherent or original), 
    it predicts mortality rates for given ages.
}
\details{
Given parameters \eqn{c} and \eqn{d} in \code{pars}, 
    the function uses the Kannisto equation \eqn{logit(m_x) = \log(c) + dx}{logit(mx) = log(c) + dx},
    to predict mortality rates for age groups \eqn{x} given by \code{ages}.
}
\examples{
data(mxM, mxF, package = "wpp2017")
mxm <- subset(mxM, name == "Germany")[,"2010-2015"]
ages <- c(0, 1, seq(5, 130, by=5))

# using original Kannisto parameters
pars <- kannisto.estimate(mxm[18:21], ages = ages[18:21])
mxm.pred <- kannisto.predict(pars$coefficients, ages = ages[22:28])
plot(ages, c(mxm[1:21], mxm.pred), type="l", log="y", 
    xlab="age", ylab="mx")
    
# Coherent Kannisto
mxf <- subset(mxF, name == "Germany")[,"2010-2015"]
copars <- cokannisto.estimate(
   mxm[18:21], mxf[18:21], ages = ages[18:21])
cmxm.pred <- kannisto.predict(copars[["male"]]$coefficients, ages = ages[22:28])
cmxf.pred <- kannisto.predict(copars[["female"]]$coefficients, ages = ages[22:28])
plot(ages, c(mxm[1:21], cmxm.pred), type="l", log="y", 
    xlab="age", ylab="mx", col="blue")
lines(ages, c(mxf[1:21], cmxf.pred), col="red")

}
\references{
Thatcher, A. R., Kannisto, V. and Vaupel, J. W. (1998). The Force of Mortality at Ages 80 to 120, 
volume 5 of Odense Monographs on Population Aging Series. Odense, Denmark: Odense University Press.
}
\seealso{
\code{\link{cokannisto}}, \code{\link{kannisto.estimate}}, \code{\link{cokannisto.estimate}}
}
