% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plot.tracks}
\alias{plot.tracks}
\title{Plot Tracks in 2D}
\usage{
\method{plot}{tracks}(x, dims = c("x", "y"), add = F,
  col = order(names(x)), pch.start = 1, pch.end = NULL, cex = 0.5, ...)
}
\arguments{
\item{x}{the tracks to be plotted.}

\item{dims}{a vector giving the dimensions of the track data that shall be 
plotted, e.g. \code{c('x','y')} for the \eqn{x} and \eqn{y} dimension.}

\item{add}{boolean value indicating whether the tracks are to be added to the
current plot.}

\item{col}{a specification of the color(s) to be used. This can be a vector
of size \code{length(x)}, where each entry specififes the color for the 
corresponding track.}

\item{pch.start}{point symbol with which to label the first position of the track
(see \code{\link[graphics]{points}}).}

\item{pch.end}{point symbol with which to label the last position of the track}

\item{cex}{point size for positions on the tracks.}

\item{...}{additional parameters (e.g. xlab, ylab).
to be passed to \code{\link[graphics]{plot}}
(for \code{add=FALSE}) or \code{\link[graphics]{points}} (for \code{add=TRUE}), 
respectively.}
}
\description{
Plots tracks contained in a "tracks" object into a twodimensional space
pallelel to the data's axes.
}
\details{
One dimension of the data (by default \eqn{y}) is plotted against 
another (by default \eqn{x}). The dimesions can be chosen by means of the 
parameter \code{dims} and the axes can be labeled accordingly with the aid 
of \code{xlab} and \code{ylab}. The color can be set through \code{col}.
If the tracks should be added to an existing plot, \code{add} is to be set 
to \code{TRUE}.
}
\seealso{
\code{\link{plot3d}}
}

