% Generated by roxygen2 (4.0.1): do not edit by hand
\name{mplus.traceplot}
\alias{mplus.traceplot}
\title{Plot the samples for each MCMC chain as a function of iterations}
\usage{
mplus.traceplot(mplus.model, rows = 4, cols = 4, parameters_only = TRUE)
}
\arguments{
\item{mplus.model}{An Mplus model extracted by the \code{readModels} function.}

\item{rows}{Number of rows to display per plot.}

\item{cols}{Optional. Number of columns to display per plot.}

\item{parameters_only}{Optional. If TRUE, only the unstandardized parameter estimates from the MCMC
draws will be displayed (as opposed to standardized estimates, r-square estimates, etc.).
The unstandardized estimates all begin with "Parameter" in the Mplus gh5 output.}
}
\value{
No value is returned by this function.
  Called for the side effect of displaying an MCMC chains traceplot.
}
\description{
Displays a traceplot of the MCMC draws from the poster distribution of each parameter estimate for a Bayesian Mplus model.
This function requires that 1) PLOT: TYPE=PLOT2; be included in the Mplus input file, 2) a gh5 file be present corresponding
to the Mplus output file (and containing a bayesian_data section), and 3) that the rhdf5 package be installed to allow
the gh5 file to be imported.
}
\details{
A multi-panel plot is drawn to the screen and the user is prompted to display the next plot if more than rows x columns estimates are
in the model.
}
\note{
Trace and density plots can also be obtained using the coda package and the bparameters
  element of the mplus.model object. This requires that the posterior draws
  be saved using SAVEDATA: BPARAMETERS syntax. See example below.
}
\examples{
\dontrun{
  myModel <- readModels("BayesModel_WithGH5MCMC.out")
  mplus.traceplot(myModel, rows=2, cols=3)

  #alternative using the coda package
  library(coda)
  plot(myModel$bparameters$valid_draw)
}
}
\author{
Joseph Glass, Michael Hallquist
}
\seealso{
\code{\link{plot.mcmc}}
}
\keyword{interface}

