\name{createTable}
\alias{createTable}
\title{Create tables}
\usage{
  createTable(modelList,
    filename = file.path(getwd(), "Model Comparison.html"),
    sortby = "AICC", display = TRUE, latex = FALSE,
    dropCols = c("Observations"), label = NULL)
}
\arguments{
  \item{modelList}{A list of model details returned by
  extractModelSummaries}

  \item{filename}{The name of HTML table file. Defaults to
  model comparison.html}

  \item{sortby}{The name of a field on which to sort.
  Defaults to "AICC". "BIC" and "AIC" are options.}

  \item{display}{Logical, whether to load the HTML table in
  the browser after creating it. Defaults to \code{TRUE}.}

  \item{latex}{Logical, whether to return a LaTeX table or
  not.}

  \item{dropCols}{A vector of the columns to be dropped}

  \item{label}{Defaults to \code{NULL}}
}
\value{
  A file or \code{xtable} object
}
\description{
  This function generates an HTML table from a list of
  models generated by extractModelSummaries.
}
\examples{
\dontrun{
  createTable(myModels, "C:/Documents and Settings/Michael/My Documents/Mplus Stuff/", "my comparison.html", sortby="BIC")
}
}
\author{
  Michael Hallquist
}
\keyword{internal}

