% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity.R
\name{getSimilarityMatrix}
\alias{getSimilarityMatrix}
\title{Generate a similarity matrix}
\usage{
getSimilarityMatrix(
  readouts,
  self = NULL,
  upper = TRUE,
  method = "rsquared",
  strategy = "atLeastOne",
  minMeasures = 3L,
  post.norm = FALSE,
  parallel = FALSE
)
}
\arguments{
\item{readouts}{The readouts that are used to generate the similarity matrix}

\item{self}{Values to set on the diagonal of the matrix. If NULL, the values that are returned by the method are used.}

\item{upper}{Only used with "rsquared". If TRUE, generates the upper triangle.}

\item{method}{The method to use as a string. Possible values for the string are "rsquared" and any method that is accepted by stats::dist.
In case of stats::dist we are using the change in the values over time / compartments (columns).}

\item{strategy}{Defines the strategy how to treat 0 / NA values. Considering a pair (two lines), **atLeastOne** ignores all columns, where both are 0.
**all** takes all measures into account, independent whether they are 0 or not.}

\item{minMeasures}{Minimum number of measures to compare two integration sites (rows). If there are less measures, the similarity entry is NA.}

\item{post.norm}{Normalize the similarity matrix to [0,1] scale.}

\item{parallel}{Whether parallelism should be used. Number of cores is set by option mc.cores. If unset, parallel::detectCores is used.}
}
\value{
A similarity matrix.
}
\description{
Generate a similarity matrix
}
