% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiRep.R
\name{MultiRep}
\alias{MultiRep}
\alias{MultiRep,}
\alias{multirep}
\title{Replication analysis of multivariate genome-wide association signal}
\usage{
MultiRep(training.pheno = NULL, training.phenofile = NULL,
  test.pheno = NULL, test.phenofile = NULL, pheno.names = NULL,
  training.geno, test.geno)
}
\arguments{
\item{training.pheno}{An (optional) matrix or data frame contains the phenotype data for the discovery
sample, preferrably adjusted for fixed effects and population structure before multivariate GWA analysis.}

\item{training.phenofile}{An (optional) plain text file contains phenotypes for the discovery sample. 
If this is provided, it will serve as \code{training.pheno}.}

\item{test.pheno}{An (optional) matrix or data frame contains the phenotype data for the replication
sample, preferrably adjusted for fixed effects and population structure.}

\item{test.phenofile}{An (optional) plain text file contains phenotypes of the replication sample. 
If this is provided, it will serve as \code{test.pheno}.}

\item{pheno.names}{A vector (length > 1) giving the column names of the phenotypes to be analyzed.}

\item{training.geno}{A matrix or data.frame that contains the discovery sample genotype dosages 
of the variants to replicate.}

\item{test.geno}{A matrix or data.frame that contains the replication sample genotype dosages 
of the variants to replicate. This object should have the same column names and order 
as \code{training.geno}.}
}
\value{
The function returns a list of 3 matrices. \code{$replication} contains the estimate of 
variant effect on the corresponding compound phenotype (\code{beta_c}), standard error (\code{s.e.}), 
replication P-value (\code{P}), and proportion of phenotypic variance explained (\code{R-squared}).
\code{$training.coef} contains the estimated coefficients in the discovery sample of each phenotype 
for each variant to construct the compound phenotype. \code{$test.coef} contains similar coefficients 
as in \code{$training.coef} but estimated in the replication sample, but these are just for the record,
NOT used in the replication procedure.
}
\description{
The function performs replication analysis of multivariate GWA signals.
}
\note{
Either \code{.pheno} or \code{.phenofile} has to be provided.
If both are provided, only \code{phenofile} will be used. Individual IDs 
in \code{.pheno} or \code{.phenofile} and \code{.geno} have to match!
}
\examples{
\dontrun{
## loading example discovery sample gwaa.data in GenABEL
data(ge03d2)

## running multivariate GWAS for 3 traits: height, weight, bmi
res <- Multivariate(gwaa.data = ge03d2, trait.cols = c(5, 6, 8), 
                    covariate.cols = c(2, 3))

## extracting 5 significant variants
(top <- res[order(res[,'P.F']),][2:6,])
snps <- rownames(top)
training.geno <- as.double(gtdata(ge03d2)[,snps])

## loading example test sample gwaa.data in GenABEL
data(ge03d2c)

## extracting genotypes of the 5 variants
test.geno <- as.double(gtdata(ge03d2c)[,snps])

## try replication
rep <- MultiRep(training.pheno = phdata(ge03d2), test.pheno = phdata(ge03d2c), 
                pheno.names = c('height', 'weight', 'bmi'),
                   training.geno = training.geno, test.geno = test.geno)
}
}
\references{
Xia Shen, ..., Gordan Lauc, Jim Wilson, Yurii Aulchenko (2014).
Multi-omic-variate analysis identified the association between 14q32.33 and 
compound N-Glycosylation of human Immunoglobulin G \emph{Submitted}.
}
\seealso{
\code{\link{Multivariate}}
}
\author{
Xia Shen
}
\keyword{multivariate,}
\keyword{replication}
