% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JLL.R
\name{JLL}
\alias{JLL}
\title{Estimates the P-dynamics from JLL-based models}
\usage{
JLL(NonOrthoFactors, N, JLLinputs, CheckInputs = F)
}
\arguments{
\item{NonOrthoFactors}{A numeric matrix (F x T) representing the time series of risk factors before the orthogonalization process.}

\item{N}{Integer. Number of country-specific spanned factors.}

\item{JLLinputs}{List of necessary inputs to estimate JLL models:
 \enumerate{
     \item Economies:  set of economies that are part of the economic system (string-vector)
     \item \code{DomUnit}: A string specifying the name of the economy assigned as the dominant unit. \cr
                 If no dominant unit is assigned, set this variable to "None".
     \item \code{WishSigmas}: Set to "1" if the user wishes to estimate the variance-covariance matrices and Cholesky factorizations \cr
                 (this can take a long time). Set to "0" if not.
     \item \code{SigmaNonOrtho}: A NULL value or an F x F matrix from the non-orthogonalized dynamics.
     \item \code{JLLModelType}: A string specifying the type of JLL model. Available options are: "JLL original", "JLL joint Sigma", or "JLL No DomUnit".
}}

\item{CheckInputs}{A logical flag to indicate whether to perform a prior consistency check on the inputs provided in \code{JLLinputs}. The default is set to FALSE}
}
\value{
List of model parameters from both the orthogonalized and non-orthogonalized versions of the JLL's based models
}
\description{
Estimates the P-dynamics from JLL-based models
}
\examples{
\donttest{
data(CM_Factors)
RF_TS <- RiskFactors
N <- 3

JLLinputs <- list(Economies = c("China", "Brazil", "Mexico", "Uruguay"), DomUnit = "China",
                  WishSigmas = 1, SigmaNonOrtho = NULL, JLLModelType = "JLL original")


JLLPara <- JLL(RF_TS, N, JLLinputs)

}
}
\references{
Jotiskhatira, Le and Lundblad (2015). "Why do interest rates in different currencies co-move?" (Journal of Financial Economics)
}
