% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap.R
\name{Bootstrap}
\alias{Bootstrap}
\title{Generates the bootstrap-related outputs}
\usage{
Bootstrap(
  ModelType,
  ModelParaPE,
  NumOutPE,
  Economies,
  InputsForOutputs,
  FactorLabels,
  JLLlist = NULL,
  GVARlist = NULL,
  WishBC = 0,
  BRWlist = NULL
)
}
\arguments{
\item{ModelType}{A character vector indicating the model type to be estimated.}

\item{ModelParaPE}{A list containing the point estimates of the model parameters. For details, refer to the outputs from the \code{\link{Optimization}} function.}

\item{NumOutPE}{The point estimate derived from numerical outputs. See the outputs from the \code{\link{NumOutputs}} function for further information.}

\item{Economies}{A character vector containing the names of the economies included in the system.}

\item{InputsForOutputs}{A list containing the necessary inputs for generating IRFs, GIRFs, FEVDs, GFEVDs and Term Premia.}

\item{FactorLabels}{A list of character vectors with labels for all variables in the model.}

\item{JLLlist}{List. Inputs for JLL model estimation (see \code{\link{JLL}} function). Default is NULL.}

\item{GVARlist}{List. Inputs for GVAR model estimation (see \code{\link{GVAR}} function). Default is NULL.}

\item{WishBC}{Whether to estimate the physical parameter model with bias correction, based on the method by Bauer, Rudebusch and Wu (2012) (see \code{\link{Bias_Correc_VAR}} function). Default is set to 0.}

\item{BRWlist}{List of necessary inputs for performing the bias-corrected estimation (see \code{\link{Bias_Correc_VAR}} function).}
}
\value{
List containing the following elements:
\itemize{
\item List of model parameters for each draw
\item List of numerical outputs (IRFs, GIRFs, FEVDs, GFEVDs and Term Premia) for each draw
\item Confidence bounds for the chosen level of significance
}
}
\description{
Generates the bootstrap-related outputs
}
\examples{
# See an example of implementation in the vignette file of this package (Section 4).

}
\references{
This function is a modified and extended version of the \code{VARirbound} function from "A toolbox for VAR analysis"
by Ambrogio Cesa-Bianchi (https://github.com/ambropo/VAR-Toolbox)
}
