% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spanned_Factors.R
\name{Spanned_Factors}
\alias{Spanned_Factors}
\title{Computes the country-specific spanned factors}
\usage{
Spanned_Factors(Yields, Economies, N)
}
\arguments{
\item{Yields}{matrix (\code{J x Td}). Bond yields for all countries.}

\item{Economies}{character vector. Names of the \code{C} economies included in the system.}

\item{N}{integer. Desired number of country-specific spanned factors (maximum allowed is \code{N = J}).}
}
\value{
matrix. Contains the \code{N} spanned factors for all countries in the system (\code{CJ x Td}).
}
\description{
Computes the country-specific spanned factors
}
\section{General Notation}{

\itemize{
  \item \code{Td}: model time series dimension
  \item \code{C}: number of countries in the system
  \item \code{N}: number of country-specific spanned factors
  \item \code{J}: number of bond yields per country used in estimation
}
}

\examples{
data(Yields)
Economies <- c("China", "Brazil", "Mexico", "Uruguay")
N <- 3
SpaFact_TS <- Spanned_Factors(Yields, Economies, N)

}
