% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{matr_Commutator_Kperm}
\alias{matr_Commutator_Kperm}
\title{Commutator for T-products of vectors}
\usage{
matr_Commutator_Kperm(perm, dims, useSparse = FALSE)
}
\arguments{
\item{perm}{vector indicating the permutation of the order
in the Kronecker product,}

\item{dims}{vector indicating the dimensions of the vectors,
use dims <- d if all dimensions are equal}

\item{useSparse}{T or F.}
}
\value{
A square permutation matrix of size \code{prod(dims)}. If \code{useSparse=TRUE} an object of the class
"dgCMatrix" is produced.
}
\description{
Produces any permutation of kronecker products of vectors of any length. An option for sparse matrix is provided, by default a
non-sparse matrix is produced. Using sparse matrices increases computation times, but far
less memory is required.
}
\examples{
dims <- c(2,3,2)
perm  <-  c(1,3,2)
matr_Commutator_Kperm(perm,dims)
perm  <- c(3,1,4,2)
dims <- 4 # All vectors with dimension 4
# If all dimensions are equal, using dims <- d instead of
# dims <- c(d,d,d,d,d,d,d,d) will be much faster.
# For example, for perm <- c(2,4,6,1,3,8,5,7) and d <- 3
# matr_Commutator_Kperm(c(2,4,6,1,3,8,5,7),3)  ## requires 2.11 secs
# matr_Commutator_Kperm(c(2,4,6,1,3,8,5,7),c(3,3,3,3,3,3,3,3))  ## requires 1326.47 secs
}
\references{
Holmquist B (1996) The d-variate vector Hermite polynomial of order. Linear
Algebra and its Applications 237/238, 155-190.

Gy., Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021, 1.2.4 Commuting T-Products of Vectors.
}
\seealso{
Other Matrices and commutators: 
\code{\link{indx_Commutator_Kmn}()},
\code{\link{indx_Commutator_Kperm}()},
\code{\link{indx_Commutator_Mixing}()},
\code{\link{indx_Commutator_Moment}()},
\code{\link{indx_Elimination}()},
\code{\link{indx_Qplication}()},
\code{\link{indx_Symmetry}()},
\code{\link{indx_UnivMomCum}()},
\code{\link{matr_Commutator_Kmn}()},
\code{\link{matr_Commutator_Mixing}()},
\code{\link{matr_Commutator_Moment}()},
\code{\link{matr_Elimination}()},
\code{\link{matr_Qplication}()},
\code{\link{matr_Symmetry}()}
}
\concept{Matrices and commutators}
