% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MomCums.r
\name{conv_Mom2CumMulti}
\alias{conv_Mom2CumMulti}
\title{Convert T-moments to T-cumulants  (multivariate)}
\usage{
conv_Mom2CumMulti(mu)
}
\arguments{
\item{mu}{the list of r d-variate moments in vector form starting from the first moment -
the vector of means - and arriving to the r-th order d-variate moment in vector form}
}
\value{
\code{Cum} the list of n vectors of d-variate cumulants
}
\description{
Obtains a vector of d-variate cumulants from a vector of
d-variate moments
}
\examples{
#Mu contains the  T-vector moments up to the fifth order of the bivariate
#standard normal distribution
mu<-list(c(0,0),c(1,0,0,1),c(0,0,0,0,0,0,0,0),c(3,0,0,1,0,1,1,0,0,1,1,0,1,0,0,3),
c(rep(0,32)))
conv_Mom2CumMulti(mu)

}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Section 3.4 formula 3.29
}
\seealso{
Other Moments and cumulants: 
\code{\link{conv_Cum2MomMulti}()},
\code{\link{conv_Cum2Mom}()},
\code{\link{conv_Mom2Cum}()}
}
\concept{Moments and cumulants}
