% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TN.R
\name{TN_corr}
\alias{TN_corr}
\title{Calculate and Visualize Plant Trait Correlation Network}
\usage{
TN_corr(traits_matrix, rThres = 0.2, pThres = 0.05)
}
\arguments{
\item{traits_matrix}{A numeric matrix where each column represents a plant trait and each row represents a sample.}

\item{rThres}{Numeric, threshold for correlation coefficient, default is 0.2. Only correlations with absolute values above this threshold will be displayed in the plot.}

\item{pThres}{Numeric, threshold for p-value, default is 0.05. Only correlations with p-values below this threshold will be displayed in the plot.}
}
\value{
Returns a correlation network plot object.
}
\description{
This function calculates correlation coefficients for given plant traits and generates a correlation network plot.
}
\details{
The function first calculates Pearson correlation coefficients between traits, then adjusts p-values using the FDR method.
Finally, it plots the correlation network using the corrplot package. The plot displays only correlations that meet both the correlation coefficient and p-value thresholds.
}
\examples{
data(WH)
WH <- WH[,4:23]
head(WH)
TN_corr(traits_matrix = WH, rThres = 0.3, pThres = 0.01)

}
\references{
\enumerate{
\item He, N., Li, Y., Liu, C., et al. (2020). Plant trait networks: improved resolution of the dimensionality of adaptation. Trends in Ecology & Evolution, 35(10), 908-918. https://doi.org/10.1016/j.tree.2020.06.003
\item Li, Y., Liu, C., Sack, L., Xu, L., Li, M., Zhang, J., & He, N. (2022). Leaf trait network architecture shifts with species‐richness and climate across forests at continental scale. Ecology Letters, 25(6), 1442-1457. https://doi.org/10.1111/ele.14009
}
}
