## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(MultivariateAnalysis)

## -----------------------------------------------------------------------------
data("Dados.CAT")
Dados.CAT

## -----------------------------------------------------------------------------
#colocando nome nos individuos
rownames(Dados.CAT)=paste0("T",1:nrow(Dados.CAT))
Dist=Distancia(Dados.CAT,Metodo = 10)
Dist

## -----------------------------------------------------------------------------
resumo=SummaryDistancia(Dist)
resumo

## -----------------------------------------------------------------------------
Dendrograma(Dist,Metodo=3)

## -----------------------------------------------------------------------------
Tocher(Dist)

## -----------------------------------------------------------------------------
CoordenadasPrincipais(Dist)

