/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;

abstract class FixedSizePriorityQueue<T> {
    private final int k;
    private final Comparator<? super T> queueingComparator;
    private final Comparator<? super T> sortingComparator;
    private final Queue<T> queue;

    FixedSizePriorityQueue(int k, Comparator<? super T> comparator) {
        Preconditions.checkArgument(k > 0);
        this.k = k;
        Preconditions.checkNotNull(comparator);
        this.queueingComparator = this.queueingComparator(comparator);
        this.sortingComparator = this.sortingComparator(comparator);
        this.queue = new PriorityQueue<T>(k + 1, this.queueingComparator);
    }

    abstract Comparator<? super T> queueingComparator(Comparator<? super T> var1);

    abstract Comparator<? super T> sortingComparator(Comparator<? super T> var1);

    public void offer(T item) {
        if (this.queue.size() < this.k) {
            this.queue.add(item);
        } else if (this.queueingComparator.compare(item, this.queue.peek()) > 0) {
            this.queue.add(item);
            this.queue.poll();
        }
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }

    public List<T> retrieve() {
        ArrayList<T> topItems = Lists.newArrayList(this.queue);
        Collections.sort(topItems, this.sortingComparator);
        return topItems;
    }

    protected T peek() {
        return this.queue.peek();
    }
}

