/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.generation;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.online.generation.Generation;
import net.myrrix.online.generation.GenerationSerializer;
import net.myrrix.online.generation.IDCluster;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;

public final class PrintGeneration {
    private PrintGeneration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File modelFile = new File(args[0]);
        File outFile = args.length > 1 ? new File(args[1]) : null;
        Generation generation = GenerationSerializer.readGeneration(modelFile);
        if (outFile == null) {
            PrintGeneration.print(generation, System.out);
        } else {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), Charsets.UTF_8);
            try {
                PrintGeneration.print(generation, out);
            }
            finally {
                ((Writer)out).close();
            }
        }
    }

    public static void print(Generation generation, Appendable out) throws IOException {
        out.append("X:\n");
        PrintGeneration.printFeatureMatrix(generation.getX(), out);
        out.append('\n');
        out.append("Y:\n");
        PrintGeneration.printFeatureMatrix(generation.getY(), out);
        out.append('\n');
        out.append("itemTagIDs:\n");
        PrintGeneration.printTagIDs(generation.getItemTagIDs(), out);
        out.append('\n');
        out.append("userTagIDs:\n");
        PrintGeneration.printTagIDs(generation.getUserTagIDs(), out);
        out.append('\n');
        out.append("Known Item IDs:\n");
        PrintGeneration.printKnownItems(generation.getKnownItemIDs(), out);
        out.append('\n');
        out.append("User Clusters / Centroids:\n");
        PrintGeneration.printCentroids(generation.getUserClusters(), out);
        out.append("Item Clusters / Centroids:\n");
        PrintGeneration.printCentroids(generation.getItemClusters(), out);
        out.append('\n');
    }

    private static void printFeatureMatrix(FastByIDMap<float[]> M, Appendable out) throws IOException {
        if (M != null) {
            for (FastByIDMap.MapEntry<float[]> entry : M.entrySet()) {
                long id = entry.getKey();
                float[] values = entry.getValue();
                StringBuilder line = new StringBuilder();
                line.append(id);
                for (float value : values) {
                    line.append('\t').append(value);
                }
                out.append(line).append('\n');
            }
        }
    }

    private static void printKnownItems(FastByIDMap<FastIDSet> known, Appendable out) throws IOException {
        if (known != null) {
            for (FastByIDMap.MapEntry<FastIDSet> entry : known.entrySet()) {
                long id = entry.getKey();
                FastIDSet keys = entry.getValue();
                StringBuilder line = new StringBuilder();
                line.append(id);
                Iterator i$ = keys.iterator();
                while (i$.hasNext()) {
                    long key = (Long)i$.next();
                    line.append('\t').append(key);
                }
                out.append(line).append('\n');
            }
        }
    }

    private static void printTagIDs(FastIDSet ids, Appendable out) throws IOException {
        LongPrimitiveIterator it = ids.iterator();
        while (it.hasNext()) {
            out.append(Long.toString(it.nextLong())).append('\n');
        }
    }

    private static void printCentroids(Iterable<IDCluster> clusters, Appendable out) throws IOException {
        if (clusters != null) {
            for (IDCluster cluster : clusters) {
                out.append(Arrays.toString(cluster.getCentroid())).append('\n');
                out.append(cluster.getMembers().toString()).append('\n');
            }
        }
    }
}

