/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.preparation;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.Vectors;

public class ToItemVectorsMapper
extends Mapper<VarLongWritable, VectorWritable, IntWritable, VectorWritable> {
    public static final String SAMPLE_SIZE = ToItemVectorsMapper.class + ".sampleSize";
    private int sampleSize;

    protected void setup(Mapper.Context ctx) throws IOException, InterruptedException {
        this.sampleSize = ctx.getConfiguration().getInt(SAMPLE_SIZE, Integer.MAX_VALUE);
    }

    protected void map(VarLongWritable rowIndex, VectorWritable vectorWritable, Mapper.Context ctx) throws IOException, InterruptedException {
        Vector userRatings = vectorWritable.get();
        int numElementsBeforeSampling = userRatings.getNumNondefaultElements();
        userRatings = Vectors.maybeSample((Vector)userRatings, (int)this.sampleSize);
        int numElementsAfterSampling = userRatings.getNumNondefaultElements();
        int column = TasteHadoopUtils.idToIndex(rowIndex.get());
        VectorWritable itemVector = new VectorWritable((Vector)new RandomAccessSparseVector(Integer.MAX_VALUE, 1));
        itemVector.setWritesLaxPrecision(true);
        Iterator iterator = userRatings.iterateNonZero();
        while (iterator.hasNext()) {
            Vector.Element elem = (Vector.Element)iterator.next();
            itemVector.get().setQuick(column, elem.get());
            ctx.write((Object)new IntWritable(elem.index()), (Object)itemVector);
        }
        ctx.getCounter((Enum)Elements.USER_RATINGS_USED).increment((long)numElementsAfterSampling);
        ctx.getCounter((Enum)Elements.USER_RATINGS_NEGLECTED).increment((long)(numElementsBeforeSampling - numElementsAfterSampling));
    }

    static enum Elements {
        USER_RATINGS_USED,
        USER_RATINGS_NEGLECTED;

    }
}

