/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.Cache;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.common.Retriever;
import org.apache.mahout.cf.taste.impl.similarity.LongPairMatchPredicate;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;
import org.apache.mahout.common.LongPair;

public final class CachingItemSimilarity
implements ItemSimilarity {
    private final ItemSimilarity similarity;
    private final Cache<LongPair, Double> similarityCache;
    private final RefreshHelper refreshHelper;

    public CachingItemSimilarity(ItemSimilarity similarity, DataModel dataModel) throws TasteException {
        this(similarity, dataModel.getNumItems());
    }

    public CachingItemSimilarity(ItemSimilarity similarity, int maxCacheSize) {
        Preconditions.checkArgument(similarity != null, "similarity is null");
        this.similarity = similarity;
        this.similarityCache = new Cache<LongPair, Double>(new SimilarityRetriever(similarity), maxCacheSize);
        this.refreshHelper = new RefreshHelper(new Callable<Void>(){

            @Override
            public Void call() {
                CachingItemSimilarity.this.similarityCache.clear();
                return null;
            }
        });
        this.refreshHelper.addDependency(similarity);
    }

    @Override
    public double itemSimilarity(long itemID1, long itemID2) throws TasteException {
        LongPair key = itemID1 < itemID2 ? new LongPair(itemID1, itemID2) : new LongPair(itemID2, itemID1);
        return this.similarityCache.get(key);
    }

    @Override
    public double[] itemSimilarities(long itemID1, long[] itemID2s) throws TasteException {
        int length = itemID2s.length;
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.itemSimilarity(itemID1, itemID2s[i]);
        }
        return result;
    }

    @Override
    public long[] allSimilarItemIDs(long itemID) throws TasteException {
        return this.similarity.allSimilarItemIDs(itemID);
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.refreshHelper.refresh(alreadyRefreshed);
    }

    public void clearCacheForItem(long itemID) {
        this.similarityCache.removeKeysMatching(new LongPairMatchPredicate(itemID));
    }

    private static final class SimilarityRetriever
    implements Retriever<LongPair, Double> {
        private final ItemSimilarity similarity;

        private SimilarityRetriever(ItemSimilarity similarity) {
            this.similarity = similarity;
        }

        @Override
        public Double get(LongPair key) throws TasteException {
            return this.similarity.itemSimilarity(key.getFirst(), key.getSecond());
        }
    }
}

