AnnotateDataframe <-
function(anydf,selections="",filename="",hyper="HYPERLINK",xldiv=";",smt=FALSE,sme=FALSE,div="---",keeplocusIDs=FALSE,keepNS=FALSE,kp=TRUE,quiet=TRUE,neigh=TRUE,showurl=FALSE,FlankingDistance=100000,suppressColCheck=FALSE)
   {
   if(class(anydf)!="data.frame")
     stop("object was not a data frame")
   if(selections[1]=="")
     print("no columns were selected in the data frame. Program will proceed assuming these are the list of markers.")
   if(length(selections)==1 & !suppressColCheck)
     print("WARNING: only one column was selected from the data frame")
   if(nrow(anydf)>200)
      print(paste("Your data frame is",nrow(anydf),"lines long. Program will continue - this is just advice"))

   if(selections[1]!="")
      {
      nonmatches<-selections[!(selections %in% colnames(anydf))]
      if(length(nonmatches)>0)
         {
         writeLines("The following columns were not found in the loaded data frame")
         writeLines(paste(nonmatches,collapse=","))
         stop(print("NCBI2R error. Please try again."))
         }
      }

   snplist<-anydf[,selections[1]]

   snps<-GetSNPInfo(snplist,showurl=showurl)
   print("GetSNPInfo has been performed and information for identified genes will now be found.")
   if(length(unique(snps$species[snps$species!=""]))!=1) 
      stop("NCBI2R error - More than one species in the snps dataframe. Can only continue this step if there is only one species.")
   flush.console()   
   org<-unique(snps$species[snps$species!=""])
   snps$species<-NULL

   if(length(selections)>1)
      {
      oldnames<-names(snps)
      snps<-as.data.frame(cbind(snps,anydf[,selections[2:length(selections)]]))
      names(snps)<-c(oldnames,selections[2:length(selections)])
      }
  snps<-SplitGenes(snps)
  genes<-try(GetGeneInfo(snps$locusID,div=div,quiet=quiet,showurl=showurl))
   if(class(genes)=="try-error")
     stop("NCBI2R error ADf-001: Unable to GetGeneInfo within function AnnotateDataframe")
   genes$org_ref_taxname<-NULL
   genes$org_ref_commonname<-NULL
   if(is.null(genes))
      {
      newsnps<-snps          
      } else {
      if(length(unique(genes$approx))==1 & genes$approx[1]==0)
         {
         writeLines("Information for genes has been found - no genes listed have interim titles (i.e. temporary and unofficial names)")
          } else {
         writeLines("Information for genes has been found - AT LEAST one gene listed has  titles that are temporary or unofficial names)")
         }
      newsnps<-try(MergeSNPsGenes(snps,genes,quiet=TRUE))
      if(class(newsnps)=="try-error")
        stop("NCBI2R error Adf-002: Unable to MergeSNPsGenes within function AnnotateDataframe")
      }
   flush.console()
   if(neigh){
     Nei<-try(GetNeighGenes(newsnps$chr,newsnps$chrpos,org=org,sme=sme,smt=smt,div=div,showurl=showurl,html=TRUE,FlankingDistance=FlankingDistance))
     if(class(Nei)=="try-error")
        stop("NCBI2R error Adf-003: Unable to use GetNeighGenes within function AnnotateDataframe")
     Nei$chr<-NULL
     names(Nei)[1:5]<-paste("N.",names(Nei)[1:5],sep="")
     flush.console()
     snpsNei<-as.data.frame(cbind(newsnps,Nei),stringsAsFactors=FALSE)
     } else {
     snpsNei<-newsnps
     }

   snpsNei<-order.to.original.list(snps$marker,snpsNei,"marker")

   if(filename!="")
      MakeHTML(snpsNei,filename,keeplocusIDs=keeplocusIDs,keepNS=keepNS,kp=kp)
   return(snpsNei)
   } 

