% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_water.R
\name{calibrate_water}
\alias{calibrate_water}
\title{calibrate_water}
\usage{
calibrate_water(
  inpath,
  outpath,
  site,
  calibration_half_width = 14,
  filter_data = TRUE,
  force_cal_to_beginning = FALSE,
  force_cal_to_end = FALSE,
  r2_thres = 0.95,
  slope_tolerance = 9999
)
}
\arguments{
\item{inpath}{Directory path to input (monthly) NEON HDF5 files.}

\item{outpath}{Directory path to save output data file.
(For now, 1 per site).}

\item{site}{Four-letter NEON code for site being processed.}

\item{calibration_half_width}{Determines the range of standard measurements
to use in determining the calibration regression dataset. Creates
a moving window that is \code{2*calibration_half_width} days wide.
Default is set to 14 for a 28 day moving window.}

\item{filter_data}{Apply median absolute deviation filter from Brock 86 to
remove impulse spikes?}

\item{force_cal_to_beginning}{Extend first calibration to
the beginning of the file?}

\item{force_cal_to_end}{Extend last calibration to the end of the file?}

\item{r2_thres}{Minimum r2 threshold of an "acceptable" calibration. Acts to
remove calibration periods where a measurement error makes
relationship nonlinear. Default = 0.95}

\item{slope_tolerance}{How different from 1 should we allow
'passing' regression slopes to be? Experimental parameter,
off by default (e.g., default slope parameter = 9999)}
}
\value{
nothing to the workspace, but creates a new output file of
calibrated water isotope data.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This function uses NEON validation data to apply drift corrections to
measured ambient water isotope ratios. In brief, ambient water isotope
ratios are calibrated by generating regressions using reference water
measurements bracketing an ambient period. Three reference waters are
measured once per day, with several injections per reference water.
Due to memory effects, only the last three are used currently to generate
calibration equations. Regressions between measured d18O and d2H values
and NEON-provisioned known reference values are generated, and used to
calibrate the period of ambient measurements between them if the r2 of
the regression is greater than a threshold value (by default, this is 0.95).
Most of this function deals with selecting the appropriate calibration data
and determining calibration quality. This function also contains a wrapper
for \code{calibrate_ambient_water_linreg}, which calibrates the ambient
water data using the calibration parameters generated in this function.
This function also copies over data in the qfqm and ucrt hdf5 data groups.
}
\details{
\emph{IMPORTANT NOTE} Currently this function does not apply a correction for
humidity dependence of Picarro isotopic measurements. This is because the
data to implement these corrections is not yet publicly available.
Caution is suggested when analyzing data at low humidities, below ~5000 ppm,
with likely higher biases at lower humidity values.

Additionally, please note that this function is meant to work on \emph{all} files
for a given site at the same time. A more flexible version that can handle
all files or monthly files will be added to a future release.
}
\author{
Rich Fiorella \email{rfiorella@lanl.gov}
}
