% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngchmshaidy.R
\name{chmSetCollection}
\alias{chmSetCollection}
\title{Set the user's current server and/or collection}
\usage{
chmSetCollection(path)
}
\arguments{
\item{path}{A single character string specifying the path of the collection
to be set. The path should be in the format '//server/collection'.}
}
\value{
None. This function is used for its side effects of setting the current
server and collection.
}
\description{
The path is a sequence of components separated by slashes (/).
If the path begins with a double slash (//) the following
component is interpreted as a server name. If the server name is
omitted (i.e. empty) the default server will be used.  If the path
does not begin with a double slash, the current server will be used.
}
\details{
If the path begins with a slash, the components (following the
server, if specified) are interpreted relative to
the root collection of the server concerned.  Otherwise, they
are interpreted relative to the current collection.

The interpretation of each path component is server specific.
}
\seealso{
\code{\link[=chmCurrentCollection]{chmCurrentCollection()}}

\code{\link[=chmServer]{chmServer()}}

\code{\link[=chmListServers]{chmListServers()}}
}
