% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{updateColor}
\alias{updateColor}
\title{Update color of a selection}
\usage{
updateColor(NGLVieweR_proxy, name, color)
}
\arguments{
\item{NGLVieweR_proxy}{A NGLVieweR object.}

\item{name}{Name of selection to alter the color.}

\item{color}{Can be a colorValue (color name or HEX code) or colorScheme (e.g. "element", "resname", "random" or "residueindex").
For a full list of options, see the "Colormaker" section in the official \href{http://nglviewer.org/ngl/api/}{NGL.js} manual.}
}
\value{
API call containing \code{NGLVieweR} \code{id} and list of message parameters.
}
\description{
Update color of an existing NGLVieweR selection in Shinymode.
}
\examples{
\dontrun{
NGLVieweR_proxy("structure") \%>\%
     updateColor("cartoon", "red")
}

if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    titlePanel("Viewer with API inputs"),
    sidebarLayout(
      sidebarPanel(
        colourInput("color", "red", "red"),
        actionButton("update", "Update"),
      ),
      mainPanel(
        NGLVieweROutput("structure")
      )
    )
  )
  server <- function(input, output) {
    output$structure <- renderNGLVieweR({
      NGLVieweR("7CID") \%>\%
        addRepresentation("cartoon",
          param = list(name = "cartoon", color = "residueindex")
        )
    })
    observeEvent(input$update, {
      NGLVieweR_proxy("structure") \%>\%
        updateColor("cartoon", isolate(input$color))
    })
  }
  shinyApp(ui, server)
}
}
\seealso{
\itemize{
\item \code{\link[=NGLVieweR_example]{NGLVieweR_example()}} See example "updateColor".
}

Other updates: 
\code{\link{updateRepresentation}()},
\code{\link{updateStage}()},
\code{\link{updateVisibility}()}
}
\concept{updates}
