% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_waiting_list.R
\name{create_waiting_list}
\alias{create_waiting_list}
\title{Create Waiting List}
\usage{
create_waiting_list(
  n,
  mean_arrival_rate,
  mean_wait,
  start_date = Sys.Date(),
  limit_removals = TRUE,
  sd = 0,
  rott = 0,
  ...
)
}
\arguments{
\item{n}{Numeric value of rate of demand in same units as target wait
\itemize{
\item e.g. if target wait is weeks, then demand in units of patients/week.
}}

\item{mean_arrival_rate}{Numeric value of mean daily arrival rate.}

\item{mean_wait}{Numeric value of mean wait time for treatment/on waiting
list.}

\item{start_date}{Character value of date from which to start generated
waiting list.}

\item{limit_removals}{Defaults to TRUE}

\item{sd}{Numeric value, standard deviation. Defaults to 0.}

\item{rott}{Numeric value, proportion of referrals to be randomly flagged
as ROTT. Defaults to 0.}

\item{...}{Container for the list}
}
\value{
A tibble of a random generated list of patients with addition_date,
removal_date, wait_length and rott status for each patient
}
\description{
Creates a waiting list using the parameters specified
}
\examples{
create_waiting_list(366, 50, 21, "2024-01-01", 10, 0.1)

}
