% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pathfinder.R
\name{findPathF2}
\alias{findPathF2}
\title{Find best subset of points for follow-up experiments, using F2 metric}
\usage{
findPathF2(tp, y, training, numSubSamples, spline = 1, resampleTraining = T,
  iter = 20, knots = 100, numPerts = 1000, fast = T, mult = F)
}
\arguments{
\item{tp}{A numerical vector of time points (or spatial coordinates along a single axis)}

\item{y}{A numerical vector of measurements (of the control).  If \code{mult==TRUE}, then this will be a matrix, where each column would be the y that corresponds with each training matrix.}

\item{training}{This is a numerical matrix of training data, where the rows represent different samples, columns represent different time points (or points on a single spatial axis), and the values correspond to measurements.   (If \code{mult==TRUE}, then this is instead a list of training matrices).}

\item{numSubSamples}{integer that represents the number of time points that will be subsampled}

\item{spline}{A positive integer representing the spline used to interpolate between knots when generating perturbations.  Note that this does NOT designate the spline used when calculating the L2-error.}

\item{resampleTraining}{A boolean designating whether the exact training data should be used (False) or whether a probability distribution of curves should be generated and training curves resampled (True).}

\item{iter}{A positive integer, representing the maximum number of iterations employed during time warping (see time_warping in fdasrvf library)}

\item{knots}{A positive integer-- for time warping to work optimally, the points must be evenly sampled.  This determines how many points do we evenly sample before conducting time warping}

\item{numPerts}{a positive integer, representing the number of sampled curves to output.}

\item{fast}{is a boolean, which determines whether the algorithm runs in fast mode where the sum of the perturbations is calculated prior to integration.}

\item{mult}{is a boolean, which will determine whether multiple genes are considered at once.}
}
\value{
An integer vector of the indices of the time points selected to be subsampled.  The actual time points can be found by \code{tp[output]}.  The length of this vector should be \code{numSubSamples}.
}
\description{
findPathF2 finds the best subset of points to sample from a time course (or spatial axis, along a single axis), based on a set of example curves. Specifically, it compares between a control curve and a set of experimental curves.
}
\examples{
#load data:
# a matrix with 12 rows, representing months (time) 
# and 35 columns, representing cities (experiments) 
mat=CanadianWeather$monthlyTemp 
y=CanadianWeather$monthlyTemp[,"Resolute"]
#find a set of points that help predict the shape of the curve
\donttest{a=findPathF2(c(1:12), y, mat, 5, numPerts=3) #make numPerts>=20 for real data}
\donttest{print(a) #indices of months to select for follow-up experiments}
\donttest{print(rownames(CanadianWeather$monthlyTemp)[a]) #month names selected}


}
