% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_percolation.R
\name{nlm_percolation}
\alias{nlm_percolation}
\title{nlm_percolation}
\usage{
nlm_percolation(ncol, nrow, resolution = 1, prob = 0.5)
}
\arguments{
\item{ncol}{[\code{numerical(1)}]\cr
Number of columns for the raster.}

\item{nrow}{[\code{numerical(1)}]\cr
Number of rows for the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{prob}{[\code{numerical(1)}]\cr
Probability value for setting a cell either to 0 or 1.}
}
\value{
RasterLayer
}
\description{
Create a random percolation neutral landscape model.
}
\details{
The simulation of a random percolation map is accomplished in two steps:

\itemize{
 \item{Initialization: }{ Setup matrix of size (\code{ncol}*\code{nrow})}
 \item{Map generation: }{ For each cell in the matrix a single uniformly
 distributed random number is generated and tested against a probability
 \code{prob}. If the random number is smaller than \code{prob}, the cell is set to
 TRUE - if it is higher the cell is set to FALSE.}
}

The proportion of 0 and 1 is thus controlled with the argument \code{prob}.
}
\examples{
# simulate percolation model
percolation <- nlm_percolation(ncol = 100, nrow = 100, prob=0.5)
\dontrun{
# visualize the NLM
util_plot(percolation, discrete = TRUE)
}
}
\references{
1. Gardner RH, O'Neill R V, Turner MG, Dale VH. 1989. Quantifying
scale-dependent effects of animal movement with simple percolation models.
\emph{ Landscape Ecology} 3:217 - 227.

2. Gustafson, E.J. & Parker, G.R. (1992) Relationships between landcover
proportion and indices of landscape spatial pattern. \emph{Landscape Ecology}
, 7, 101 - 110.
}
