% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMreadSimModTab.R
\name{NMreadSimModTabOne}
\alias{NMreadSimModTabOne}
\title{Read simulation results from an rds or a NMsimModTab object}
\usage{
NMreadSimModTabOne(
  modtab,
  check.time = FALSE,
  dir.sims,
  wait = FALSE,
  quiet = FALSE,
  skip.missing = FALSE,
  as.fun
)
}
\arguments{
\item{check.time}{If found, check whether `fst` file modification
time is newer than `rds` file. The `fst` is generated based on
information in `rds`, but notice that some systems don't
preserve the file modification times. Becasue of that,
`check.time` is `FALSE` by default.}

\item{dir.sims}{By default, `NMreadSim` will use information about
the relative path from the results table file (`_paths.rds`)
to the Nonmem simulation results. If these paths have changed,
or for other reasons this doesn't work, you can use the
`dir.sims` argument to specify where to find the Nonmem
simulation results. If an `.fst` file was already generated
and is found next to the `_paths.rds`, the path to the Nonmem
simulation results is not used.}

\item{wait}{If simulations seem to not be done yet, wait for them
to finish? If not, an error will be thrown. If you choose to
wait, the risk is results never come. `NMreadSim` will be
waiting for an `lst` file. If Nonmem fails, it will normally
generate an `lst` file. But if `NMTRAN` fails (checks of
control stream prior to running Nonmem), the `lst` file is not
generated.  Default is not to wait.}

\item{quiet}{Turn off some messages about what is going on?
Default is to report the messages.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say `tibble::as_tibble`) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}
}
\description{
Read simulation results from an rds or a NMsimModTab object
}
\keyword{internal}
