% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addEVID2.R
\name{addEVID2}
\alias{addEVID2}
\title{Add simulation records to dosing records}
\usage{
addEVID2(doses, time.sim, CMT, EVID = 2, as.fun)
}
\arguments{
\item{doses}{dosing records Nonmem style (EVID==1 records from a
data set)}

\item{time.sim}{A numerical vector with simulation times. Can also
be a data.frame in which case it must contain a `TIME` column
and is merged with subjects found in `doses`. The latter
feature is experimental.}

\item{CMT}{The compartment in which to insert the EVID=2
records. If longer than one, the records will be repeated in
all the specified compartments. If a data.frame, covariates
can be specified.}

\item{EVID}{The value to put in the EVID column for the created
rows. Default is 2 but 0 may be prefered even for simulation.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say `tibble::as_tibble`) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}
}
\value{
A data.frame with dosing records
}
\description{
Performs the simple job of adding simulation events to all
subjects in a data set. Copies over columns that are not varying
at subject level (i.e. non-variying covariates).
}
\details{
The resulting data set is ordered by ID, TIME, and
    EVID. You may have to reorder for your specific needs.
}
\examples{
(doses1 <- NMcreateDoses(TIME=c(0,12,24,36),AMT=c(2,1)))
addEVID2(doses1,time.sim=seq(0,28,by=4),CMT=2)

## two named compartments
dt.doses <- NMcreateDoses(TIME=c(0,12),AMT=10,CMT=1)
seq.time <- c(0,4,12,24)
dt.cmt <- data.frame(CMT=c(2,3),analyte=c("parent","metabolite"))
res <- addEVID2(dt.doses,time.sim=seq.time,CMT=dt.cmt)

## Separate sampling schemes depending on covariate values
dt.doses <- NMcreateDoses(TIME=data.frame(regimen=c("SD","MD","MD"),TIME=c(0,0,12)),AMT=10,CMT=1)

seq.time.sd <- data.frame(regimen="SD",TIME=seq(0,6))
seq.time.md <- data.frame(regimen="MD",TIME=c(0,4,12,24))
seq.time <- rbind(seq.time.sd,seq.time.md)
addEVID2(dt.doses,time.sim=seq.time,CMT=2)

## an observed sample scheme and additional simulation times
df.doses <- NMcreateDoses(TIME=0,AMT=50,addl=list(ADDL=2,II=24))
dense <- c(seq(1,3,by=.1),4:6,seq(8,12,by=4),18,24)
trough <- seq(0,3*24,by=24)
sim.extra <- seq(0,(24*3),by=2)
time.all <- c(dense,dense+24*3,trough,sim.extra)
time.all <- sort(unique(time.all))
dt.sample <- data.frame(TIME=time.all)
dt.sample$isobs <- as.numeric(dt.sample$TIME\%in\%c(dense,trough))
dat.sim <- addEVID2(dt.doses,time.sim=dt.sample,CMT=2)

}
