% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Numerical_Differentiation.R
\name{Finite.step}
\alias{Finite.step}
\title{Finite Step Differentiation}
\usage{
Finite.step(f, point, h)
}
\arguments{
\item{f}{Function to be derived.  Does not have to be defined \code{f<-}...}

\item{point}{Point to be evaluated for derivative of a given function \code{f}.}

\item{h}{Step difference used for deriavite.}
}
\value{
Returns the mean value of the positive and negative steps from the \code{point}.
}
\description{
Determines numerical derivative of a given function using projected the finite step method.  Used to compare \code{NNS.diff} results.
}
\examples{
f<- function(x) sin(x)/x
Finite.step(f,4.1,.1)

}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{differentiation,}
\keyword{finite}
\keyword{method,}
\keyword{numerical}
\keyword{secant}
\keyword{step}

