% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partition_Map.R
\name{NNS.part}
\alias{NNS.part}
\title{NNS Partition Map}
\usage{
NNS.part(x, y, Voronoi = FALSE, type = NULL, order = NULL,
  overfit = FALSE, noise.reduction = "mean")
}
\arguments{
\item{x}{Variable 1}

\item{y}{Variable 2}

\item{Voronoi}{Displays a Voronoi type diagram using partial moment quadrants.  Defaults to FALSE.}

\item{type}{Controls the partitioning basis.  Set to \code{type="XONLY"} for X-axis based partitioning.  Defaults to NULL for both X and Y-axis partitioning.}

\item{order}{Number of partial moment quadrants to be generated.  \code{order="max"} will institute a perfect fit.}

\item{overfit}{Reduces minimum number of necessary observations in a quadrant to 1 when \code{overfit=TRUE}.  In the instances where \code{"regression.points"} fail to be generated in the output, re-run partitioning with \code{overfit=TRUE} for the given \code{order}.}

\item{noise.reduction}{\code{noise.reduction="median"} uses medians instead of means for partitions, while \code{noise.reduction="mode"} uses modes instead of means for partitions.  Defaults to \code{noise.reduction="mean"}, while \code{noise.reduction=NULL} will partition quadrant to a single observation for a given \code{order}.}
}
\value{
Returns both a dataframe \code{"df"} of X and Y observations with their partition assignment in the 3d column; and the regression points \code{"regression.points"} for that given \code{order}.
}
\description{
Creates partitions based on quadrant means, assigning observations to those quadrants.  Needed for correlation, dependence, regression routines.  Default degree = 1 for area, but routines have their own conditional degree specifications built in
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
NNS.part(x,y)
## Dataframe of observations and partitions
NNS.part(x,y,order=1)$df
## Regression points
NNS.part(x,y,order=1)$regression.points
## Voronoi style plot
NNS.part(x,y,Voronoi=TRUE)
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{cluster}
\keyword{partitioning,}

