% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmsNiWlogpdf.R
\name{mmsNiWlogpdf}
\alias{mmsNiWlogpdf}
\title{Probability density function of multiple structured Normal inverse Wishart}
\usage{
mmsNiWlogpdf(U_xi, U_psi, U_Sigma, U_xi0, U_psi0, U_B0, U_Sigma0, U_df0)
}
\arguments{
\item{U_xi}{a list of length n of observed mean vectors, each of dimension p}

\item{U_psi}{a list of length n of observed skew vectors of dimension p}

\item{U_Sigma}{a list of length n of observed covariance matrices, each of dimension p x p}

\item{U_xi0}{a list of length K of mean vector parameters for sNiW, each of dimension p}

\item{U_psi0}{a list of length K of mean vector parameters for sNiW, each of dimension p}

\item{U_B0}{a list of length K of sturcturing matrix parameters for sNiW, each of dimension 2 x 2}

\item{U_Sigma0}{a list of length K of covariance matrix parameters for sNiW, each of dimension p x p}

\item{U_df0}{a list of length K of degrees of freedom parameters for sNiW, each of dimension p x p}
}
\description{
Probability density function of structured Normal inverse Wishart (sNiW)
for multiple inputs, on the log scale.
}
\examples{
hyperG0 <- list()
hyperG0$b_xi <- c(-1.6983129, -0.4819131)
hyperG0$b_psi <- c(-0.0641866, -0.7606068)
hyperG0$kappa <- 0.001
hyperG0$D_xi <- 16.951313
hyperG0$D_psi <- 1.255192
hyperG0$nu <- 27.67656
hyperG0$lambda <- matrix(c(2.3397761, -0.3975259,-0.3975259, 1.9601773), ncol=2)

xi_list <- list()
psi_list <- list()
S_list <- list()
for(k in 1:1000){
 NNiW <- rNNiW(hyperG0, diagVar=FALSE)
 xi_list[[k]] <- NNiW[["xi"]]
 psi_list[[k]] <- NNiW[["psi"]]
 S_list[[k]] <- NNiW[["S"]]
}
mmsNiWlogpdf(U_xi=xi_list, U_psi=psi_list, U_Sigma=S_list,
            U_xi0=list(hyperG0$b_xi), U_psi0=list(hyperG0$b_psi) ,
            U_B0=list(diag(c(hyperG0$D_xi, hyperG0$D_psi))) ,
            U_Sigma0=list(hyperG0$lambda), U_df0=list(hyperG0$nu))


hyperG0 <- list()
hyperG0$b_xi <- c(-1.6983129)
hyperG0$b_psi <- c(-0.0641866)
hyperG0$kappa <- 0.001
hyperG0$D_xi <- 16.951313
hyperG0$D_psi <- 1.255192
hyperG0$nu <- 27.67656
hyperG0$lambda <- matrix(c(2.3397761), ncol=1)
#'xi_list <- list()
psi_list <- list()
S_list <- list()
for(k in 1:1000){
 NNiW <- rNNiW(hyperG0, diagVar=FALSE)
 xi_list[[k]] <- NNiW[["xi"]]
 psi_list[[k]] <- NNiW[["psi"]]
 S_list[[k]] <- NNiW[["S"]]
}

mmsNiWlogpdf(U_xi=xi_list, U_psi=psi_list, U_Sigma=S_list,
            U_xi0=list(hyperG0$b_xi), U_psi0=list(hyperG0$b_psi) ,
            U_B0=list(diag(c(hyperG0$D_xi, hyperG0$D_psi))) ,
            U_Sigma0=list(hyperG0$lambda), U_df0=list(hyperG0$nu))

}
