% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{Sstep.Clutter.Full.RB}
\alias{Sstep.Clutter.Full.RB}
\title{Sequential Importance Sampling under Clutter Environment}
\usage{
Sstep.Clutter.Full.RB(mm, xx, logww, yyy, par, xdim, ydim, resample.sch)
}
\arguments{
\item{mm}{the Monte Carlo sample size \code{m}.}

\item{xx}{the samples in the last iteration.}

\item{logww}{the log weight in the last iteration.}

\item{yyy}{the observations.}

\item{par}{a list of parameter values \code{(ssw,ssv,pd,nyy,yr)}, where \code{ssw} is the standard deviation in the state equation,
\code{ssv} is the standard deviation for the observation noise, \code{pd} is the probability to observe the true signal, \code{nyy} the dimension of the data,
and \code{yr} is the range of the data.}

\item{xdim}{the dimension of the state varible \code{x_t}.}

\item{ydim}{the dimension of the observation \code{y_t}.}

\item{resample.sch}{a binary vector of length \code{obs}, reflecting the resampling schedule. resample.sch[i]= 1 indicating resample should be carried out at step \code{i}.}
}
\value{
The function returns a list with the following components:
\item{xx}{the new sample.}
\item{logww}{the log weights.}
\item{xhat}{the fitted vlaues.}
\item{xhatRB}{the fitted values using Rao-Blackwellization.}
}
\description{
This function performs one step propagation using the sequential importantce sampling with full information proposal distribuiton and returns Rao-Blackwellization estimate of mean under clutter environment.
}
\references{
Tsay, R. and Chen, R. (2019). Nonlinear Time Series Analysis. Wiley, New Jersey.
}
