% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{F_test_cfarh}
\alias{F_test_cfarh}
\title{F Test for a CFAR Process with Heteroscedasticity and Irregular Observation Locations}
\usage{
F_test_cfarh(f, weight, p.max = 3, grid = 1000, df_b = 10,
  num_obs = NULL, x_pos = NULL)
}
\arguments{
\item{f}{the functional time series.}

\item{weight}{the covariance functions for noise process.}

\item{p.max}{the maximum CFAR order. Default is 3.}

\item{grid}{the number of gird points used to construct the functional time series and noise process. Default is 1000.}

\item{df_b}{the degrees of freedom for natural cubic splines. Default is 10.}

\item{num_obs}{the numbers of observations. It is a t-by-1 vector, where t is the length of time.}

\item{x_pos}{the observation location matrix. If the locations are regular, it is a t-by-(n+1) matrix with all entries 1/n.}
}
\value{
The function outputs F test statistics and their p-values.
}
\description{
F test for a CFAR process with heteroscedasticity and irregular observation locations to specify the CFAR order.
}
\references{
Liu, X., Xiao, H., and Chen, R. (2016) Convolutional autoregressive models for functional time series. \emph{Journal of Econometrics}, 194, 263-282.
}
