% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{turtleSet}
\alias{turtleSet}
\alias{turtleSet,agentMatrix-method}
\title{Create a \code{turtle} \code{agentset}}
\usage{
turtleSet(...)

\S4method{turtleSet}{agentMatrix}(...)
}
\arguments{
\item{...}{\code{AgentMatrix} objects representing the moving \code{agents}.}
}
\value{
\code{AgentMatrix} object containing all the unique \code{turtles}.
}
\description{
Report a \code{turtle} \code{agentset} containing all unique \code{turtles} provided in the inputs.
}
\details{
Duplicated \code{turtles} are identified based only on their \code{who} numbers.
         The \code{turtle} chosen for a who number is the first one given in the inputs.
         To keep all \code{turtles} from the inputs, use \code{NLset()} to
         reassign \code{who} numbers in some of the inputs, prior using
         \code{turtleSet()}, to avoid \code{turtles} with duplicated \code{who} numbers.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10), breed = "sheep")
t2 <- createTurtles(n = 2, coords = randomXYcor(w1, n = 2), breed = "wolf")
t2 <- NLset(turtles = t2, agents = t2, var = "who", val = c(10, 11))
t3 <- createTurtles(n = 1, coords = randomXYcor(w1, n = 1), breed = "sheperd")
t3 <- NLset(turtles = t3, agents = t3, var = "who", val = 12)
t4 <- turtleSet(t1, t2, t3)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#turtle-set}
}
\author{
Sarah Bauduin
}
