% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{patchRight}
\alias{patchRight}
\alias{patchRight,worldNLR,agentMatrix,numeric,numeric-method}
\title{\code{Patches} on the right}
\usage{
patchRight(world, turtles, dist, angle, torus = FALSE)

\S4method{patchRight}{worldNLR,agentMatrix,numeric,numeric}(world, turtles, dist, angle, torus = FALSE)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}

\item{dist}{Numeric. Vector of distances from the \code{turtles}. \code{dist} must be
of length 1 or of length \code{turtles}.}

\item{angle}{Numeric. Vector of angles in degrees by which the \code{turtle}'s
\code{headings} should rotate to locate the patches. Must be of length 1 or of
length \code{turtles}.}

\item{torus}{Logical to determine if the \code{world} is wrapped. Default is
\code{torus = FALSE}.}
}
\value{
Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
column \code{pycor} representing the coordinates of the \code{patches} at \code{dist}
distances of the \code{turtles} and \code{angle} to the right of their \code{headings}.
The order of the \code{patches} follows the order of the \code{turtles}.
}
\description{
Report the coordinates of the \code{patches} at the given distances of the \code{turtles}
and given \code{angle} right of their \code{headings}.
}
\details{
If a given \code{dist} value is negative, then the \code{turtle} would look backward.
If a given \code{angle} value is negative, then the \code{turtle} would
look to the left.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     If `torus = FALSE` and the `patch` at distance `dist` of a `turtle`
     and `angle` degrees to the right of its `heading` is outside the
     `world`'s extent, `NA`
     are returned for the `patch` coordinates. If `torus = TRUE`, the `patch`
     coordinates from a wrapped `world` are returned.
}\if{html}{\out{</div>}}
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
t1 <- createTurtles(n = 1, coords = cbind(xcor = 2, ycor = 2), heading = 90)
patchRight(world = w1, turtles = t1, dist = 2, angle = 90)

}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#patch-lr-and-ahead}
}
\author{
Sarah Bauduin
}
