% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmsbm.R
\name{mmsbm}
\alias{mmsbm}
\title{Dynamic mixed-membership stochastic blockmodel with covariates}
\usage{
mmsbm(
  formula.dyad,
  formula.monad = ~1,
  senderID,
  receiverID,
  nodeID = NULL,
  timeID = NULL,
  data.dyad,
  data.monad = NULL,
  n.blocks,
  n.hmmstates = 1,
  directed = TRUE,
  mmsbm.control = list()
)
}
\arguments{
\item{formula.dyad}{A \code{formula} object. The variable in \code{data.dyad} that contains 
binary edges should be used as a LHS, and any dyadic predictors 
can be included on the RHS (when no dyadic covariates are available, use \code{y ~ 1}).
Same syntax as a \code{glm} formula.}

\item{formula.monad}{An optional \code{formula} object. LHS is ignored. RHS contains 
names of nodal atrributes found in \code{data.monad}.}

\item{senderID}{Character string. Quoted name of the variable in \code{data.dyad} identifying 
the sender node. For undirected networks, the variable simply contains name of first node 
in dyad. Cannot contain special charecter "`@`".}

\item{receiverID}{Character string. Quoted name of the variable in \code{data.dyad} identifying 
the receiver node. For undirected networks, the variable simply contains name of second node 
in dyad. Cannot contain special charecter "`@`".}

\item{nodeID}{Character string. Quoted name of the variable in \code{data.monad} identifying 
a node in either \code{data.dyad[,senderID]} or \code{data.dyad[,senderID]}. If not \code{NULL},
every node \code{data.dyad[,senderID]} or \code{data.dyad[,senderID]} must be present in 
\code{data.monad[,nodeID]}. Cannot contain special charecter "`@`".}

\item{timeID}{Character string. Quoted name of the variable in both \code{data.dyad} and
\code{data.monad} indicating the time in which network (and correspding nodal atrributes)
were observed. The variable itself must be composed of integers. Cannot contain special charecter "`@`".}

\item{data.dyad}{Data frame. Sociomatrix in ``long'' (i.e. dyadic) format. Must contain at
least three variables: the sender identifier (or identifier of the first node in an undirected networks dyad),
the receiver identifier (or identifier of the second node in an undirected network dyad), and the value
of the edge between them. Currently, only edges between zero and one (inclusive) are supported.}

\item{data.monad}{Data frame. Nodal atributes. Must contain a node identifier matching the names of nodes
used in the \code{data.dyad} data frame.}

\item{n.blocks}{Integer value. How many latent groups should be used to estimate the model?}

\item{n.hmmstates}{Integer value. How many hidden Markov state should be used in the HMM? Defaults 
to 1 (i.e. no HMM).}

\item{directed}{Boolean. Is the network directed? Defaults to \code{TRUE}.}

\item{mmsbm.control}{A named list of optional algorithm control parameters.
\describe{
   \item{seed}{Integer. Seed the RNG. By default, a random seed is generated and returned for reproducibility purposes.}
   \item{nstart}{Integer. Number of random initialization trials. Defaults to 5.}
   \item{spectral}{Boolean. Type of initialization algorithm for mixed-membership vectors in static case. If \code{TRUE} (default),
               use spectral clustering with degree correction; otherwise, use kmeans algorithm.}
   \item{init_gibbs}{Boolean. Should a collapsed Gibbs sampler of non-regression mmsbm be used to initialize
               mixed-membership vectors, instead of a spectral or simple kmeans initialization?
               Setting to \code{TRUE} will result in slower initialization and faster model estimation. When \code{TRUE}, results are typically very sensitive to
               choice of alpha (see below).}            
   \item{alpha}{Numeric positive value. Concentration parameter for collapsed Gibbs sampler to find initial
                mixed-membership values when \code{init_gibbs=TRUE}. Defaults to 1.0.}            
   \item{missing}{Means of handling missing data. One of "indicator method" (default) or "listwise deletion".}  
   \item{svi}{Boolean; should stochastic variational inference be used? Defaults to \code{TRUE}.}     
   \item{vi_iter}{Number of maximum iterations in stochastic variational updates. Defaults to 5e2.}
   \item{batch_size}{When \code{svi=TRUE}, proportion of nodes sampled in each local. Defaults to 0.05 when \code{svi=TRUE}, and to 1.0 otherwise.}                                 
   \item{forget_rate}{When \code{svi=TRUE}, value between (0.5,1], controlling speed of decay of weight of prior
                       parameter values in global steps. Defaults to 0.75 when \code{svi=TRUE}, and to 0.0 otherwise.}
   \item{delay}{When \code{svi=TRUE}, non-negative value controlling weight of past iterations in global steps. Defaults to 1.0 when \code{svi=TRUE},
                and ignored otherwise.}                    
   \item{opt_iter}{Number of maximum iterations of BFGS in global step. Defaults to 10e3.}
   \item{hessian}{Boolean indicating whether the Hessian matrix of regression coefficients should e returned. Defaults to \code{TRUE}.}
   \item{assortative}{Boolean indicating whether blockmodel should be assortative (i.e. stronger connections within groups) or disassortative
                      (i.e. stronger connections between groups). Defaults to \code{TRUE}.}
   \item{mu_block}{Numeric vector with two elements: prior mean of blockmodel's main diagonal elements, and
               and prior mean of blockmodel's offdiagonal elements. Defaults to \code{c(5.0, -5.0)} if \code{assortative=TRUE} (default)
               and to \code{c(-5.0, 5.0)} otherwise.}
   \item{var_block}{Numeric vector with two positive elements: prior variance of blockmodel's main diagonal elements, and
               and prior variance of blockmodel's offdiagonal elements. Defaults to \code{c(5.0, 5.0)}.}
   \item{mu_beta}{Either single numeric value, in which case the same prior mean is applied to all monadic coefficients, or
                  an array that is \code{npredictors} by \code{n.blocks} by \code{n.hmmstates}, where \code{npredictors}
                  is the number of monadic predictors for which a prior mean is being set (prior means need not be set for all)
                  predictors). The rows in the array should be named to identify which variables a prior mean is being set for.
                  Defaults to a common prior mean of 0.0 for all monadic coefficients.}            
   \item{var_beta}{See \code{mu_beta}. Defaults to a single common prior variance of 5.0 for all (standardized) monadic coefficients.}
   \item{mu_gamma}{Either a single numeric value, in which case the same prior mean is applied to all dyadic coefficients, or
                   a named vector of numeric values (with names corresponding to the name of the variable 
                  for which a prior mean is being set). Defaults to a common prior mean of 0.0 for all dyadic coefficients.}
   \item{var_gamma}{See \code{mu_gamma}. Defaults to a single common prior variance of 5.0 for all (standardized) dyadic coefficients.}
   \item{eta}{Numeric positive value. Concentration hyper-parameter for HMM. Defaults to 1.0.}
   \item{se_sim}{Number of samples from variational posterior of latent variables on which approximation to variance-covariance
                 matrices are based. Defaults to 10.}
   \item{dyad_vcov_samp}{Maximum number of dyads to sample in computation of variance-covariance of dyadic and blockmodel parameters, when compared to 
                         ten percent of the observed dyads. Defaults to 1000.}
   \item{fixed_mm}{Optional character vector, with \code{"nodeID@timeID"} as elements, indicating which mixed-membership vectors
                   should remain constant at their initial values throughout estimation. When only one year is observed, elements should be 
                    \code{"nodeID@1"}. Typically used with \code{mm_init_t}.}                      
   \item{mm_init_t}{Matrix, \code{n.blocks} by nodes across years. Optional initial values for mixed-membership vectors.
                      Although initial values need not be provided for all nodes, column names must have a \code{nodeID@timeID} format to 
                      avoid ambiguity. When only one year is observed, names should be \code{"nodeID@1"}.}
   \item{kappa_init_t}{Matrix, \code{n.hmmstates} by number of years. Optional initial values for variational 
                  parameters for state probabilities. Columns must be named according to unique year values.}
   \item{b_init_t}{Matrix, \code{n.blocks} by \code{n.blocks}. Optional initial values for blockmodel.}
   \item{beta_init}{Array, \code{predictors} by \code{n.blocks} by \code{n.hmmstates}. Optional initial values for monadic coefficients. If }
   \item{gamma_init}{Vector. Optional initial values for dyadic coefficients.}
   \item{permute}{Boolean. Should all permutations be tested to realign initial block models in dynamic case? If \code{FALSE}, realignment is 
                 done via faster graph matching algorithm, but may not be exact. Defaults to \code{TRUE}.}
   \item{conv_tol}{Numeric value. Absolute tolerance for VI convergence. Defaults to 1e-3.}
   \item{verbose}{Boolean. Should extra information be printed as model iterates? Defaults to FALSE.}
   }}
}
\value{
Object of class \code{mmsbm}. List with named components:
    \describe{
      \item{MixedMembership}{Matrix of variational posterior of mean of mixed-membership vectors. \code{nodes} by
                             \code{n.blocks}.}
      \item{BlockModel}{\code{n.blocks} by \code{n.blocks} matrix of estimated tie log-odds between members
                        of corresponding latent groups. The blockmodel.}
      \item{vcov_blockmodel}{If \code{hessian=TRUE}, variance-covariance matrix of parameters in blockmodel, ordered in column-major order.}
      \item{MonadCoef}{Array of estimated coefficient values for monadic covariates. Has \code{n.blocks} columns,
                       and \code{n.hmmstates} slices.}
      \item{vcov_monad}{If \code{hessian=TRUE}, variance-covariance matrix of monadic coefficients.}                  
      \item{DyadCoef}{Vector estimated coefficient values for dyadic covariates.}
      \item{vcov_dyad}{If \code{hessian=TRUE}, variance-covariance matrix of dyadic coefficients.}
      \item{TransitionKernel}{Matrix of estimated HMM transition probabilities.}
      \item{Kappa}{Matrix of marginal probabilities of being in an HMM state at any given point in time. 
                   \code{n.hmmstates} by years (or whatever time interval networks are observed at).}
      \item{LowerBound}{Final LB value}
      \item{lb}{Vector of all LB across iterations, useful to check early convergence issues.}              
      \item{niter}{Final number of VI iterations.}
      \item{converged}{Convergence indicator; zero indicates failure to converge.}
      \item{NodeIndex}{Order in which nodes are stored in all return objects.}
      \item{monadic.data, dyadic.data}{Model frames used during estimation (stripped of attributes).}
      \item{forms}{Values of selected formal arguments used by other methods.}
      \item{seed}{The value of RNG seed used during estimation.}
      \item{call}{Original (unevaluated) function call.}
    }
}
\description{
The function estimates a dynamic mixed-membership stochastic
blockmodel that incorporates covariates.
}
\examples{
library(NetMix)
## Load datasets
data("lazega_dyadic")
data("lazega_monadic")
## Estimate model with 2 groups
## Setting to `hessian=TRUE` increases computation time
## but is needed if standard errors are to be computed. 
lazega_mmsbm <- mmsbm(SocializeWith ~ Coworkers,
                      ~  School + Practice + Status,
                      senderID = "Lawyer1",
                      receiverID = "Lawyer2",
                      nodeID = "Lawyer",
                      data.dyad = lazega_dyadic,
                      data.monad = lazega_monadic,
                      n.blocks = 2,
                      mmsbm.control = list(seed = 123,
                                           conv_tol = 1e-2,
                                           hessian = FALSE))

}
\author{
Santiago Olivella (olivella@unc.edu), Adeline Lo (aylo@wisc.edu), Tyler Pratt (tyler.pratt@yale.edu), Kosuke Imai (imai@harvard.edu)
}
