% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness.r
\name{robustness}
\alias{robustness}
\title{run robustness analysis for a source estimate by subsampling individual events.}
\usage{
robustness(
  x,
  type = c("edm", "backtracking", "centrality"),
  prop,
  n = 100,
  ...
)
}
\arguments{
\item{x}{\code{data.frame}, dataset with individual events and their magnitude, to be passed to \code{\link{aggr_data}}}

\item{type}{character, specifying the method, \code{'edm'}, \code{'backtracking'} and \code{'centrality'} are available.}

\item{prop}{numeric, value between zero and one, proportion of events to be sampled}

\item{n}{numeric, number of resamplings}

\item{...}{parameters to be passed to origin methods \code{\link{origin_edm}}, \code{\link{origin_backtracking}} or \code{\link{origin_centrality}}}
}
\value{
\code{data.frame} with columns
  \itemize{
        \item \code{est} origin estimated when all data is evaluated
        \item \code{rob} estimate uncertainty, computed as the proportion of resamplings when origin estimate was recovered
  }
}
\description{
run robustness analysis for a source estimate by subsampling individual events.
}
\details{
We create subsamples of individual events and their magnitude using a sampling proportion p in [0, 1]. After aggregating the data, we apply the source estimation approach. Using this result, we deduce the relative frequency of how often the source estimate obtained with the complete data set can be recovered by source estimation based on the subsample. Thus, the estimate robustness is assessed by the proportion of estimate recovery.
}
\examples{
# generate random delay data
data(ptnAth)
require(igraph)
dat <- data.frame(node  = sample(size = 500, make.names(V(ptnAth)$name), replace = TRUE),
                  time  = sample(size = 500, 1:10, replace = TRUE),
                  delay = rexp(500, rate=10))
# compute effective distance 
net <- igraph::as_adjacency_matrix(ptnAth, sparse=FALSE)
p <- net/rowSums(net)
eff <- eff_dist(p)
colnames(eff) <- paste('x.',colnames(eff),sep='')

# run robustness analysis
r5 <- robustness(x=dat, type='edm', prop=0.5, n=10, distance=eff)
summary(r5)
plot(r5)

# compare results
r9 <- robustness(x=dat, type='edm', prop=0.9, n=10, distance=eff)
plot(r9, add=TRUE, col='gray')

}
\seealso{
\code{\link{robustness-methods}}
}
