% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LCC_Bipartide.R
\name{LCC_Component}
\alias{LCC_Component}
\title{LCC_Bipartide}
\usage{
LCC_Component(g, N = 1000)
}
\arguments{
\item{g}{Bipartide Graph to be rewired}

\item{N}{Number of resamples}
}
\value{
a list with the LCC
- $LCCZ all values from the randomizations
- $mean the average LCC of the randomizations
- $sd the sd LCC of the randomizations
- $Z The Z-score
- $LCC the LCC of the original network
- $emp\_p the empirical p-value for the LCC
}
\description{
LCC size for Rewire Bipartide Network
}
\examples{
nodes = data.frame(c("D1", "D2", "D3", "D4", "D5",
                     "G1", "G2", "G3", "G4", "G6"),
                   type = c(TRUE, TRUE, TRUE, TRUE, TRUE,
                            FALSE, FALSE, FALSE, FALSE, FALSE))

g = data.frame(from = c("D1", "D2", "D2", "D3", "D4", "D5", "D5", "D3"),
               to =   c("G1", "G1", "G2", "G3", "G4", "G4", "G1", "G6"))

g = igraph::graph_from_data_frame(g, directed = FALSE, vertices = nodes)

plot(g, layout = igraph::layout.bipartite)

igraph::components(g)
LCC_BIP = LCC_Component(g)
Histogram_LCC(LCC_BIP)
}
